*******************************************************
* SAWTOOTH.SRC                                        *
*                                                     *
* This is a test program for the MC1408L8 digital-to- *
* analog converter interface to the 6821 PIA.  The    *
* program creates a sawtooth wave by continually      *
* incrementing a count and sending it to the MC1408L8.*
* The constants STEP and COUNT control the frequency  *
* and the number of conversions per cycle.            *
*******************************************************
PIA      EQU      $10001        ;base address of 6821
CRA      EQU      1*2           ;Control Register A
STEP     EQU      16            ;increment for data out
COUNT    EQU      50            ;count for delay sub.

         ORG      $8000
SAWTOOTH MOVEA.L  #PIA,A0       ;A0 -> DDRA
         MOVE.B   #$FF,(A0)     ;Port A = output
         MOVE.B   #$04,CRA(A0)  ;A0 -> Port A
         CLR.B    D0            ;init D0 = 0
LOOP     MOVE.B   D0,(A0)       ;send to MC1408L8
         ADD.B    #STEP,D0      ;inc D0 by STEP
         MOVE.W   #COUNT,D1     ;create cheap-and-dirty
HERE     DBRA     D1,HERE       ;   software delay
         BRA      LOOP          ;do it again!
         END      SAWTOOTH
